"""

    File: utils.py
    Description: 
    
        This module contains global utility functions
        
    Author: Emmett Shear
    Date  : January 28th, 2008
    Copyright (c) 2007, Justin.tv, Inc.
    
"""

import operator

def avg(lst):
    return reduce(operator.add, lst) / len(lst) 

def seq_iter(*args):
    for a in args:
        for v in a:
            yield v

class IPTrie:
    def __init__(self):
        self.prefixes = {}

    def add(self, prefix):
        prefix,length = prefix.split('/')
        prefix = sum(((int(x)/16,int(x)%16) for x in prefix.split('.')), ())
        length = int(length)
        val = self.prefixes
        while length > 4:
            if val == True: return
            if prefix[0] not in val:
                val[prefix[0]] = {}
            val = val[prefix[0]]
            prefix = prefix[1:]
            length -= 4
        for x in xrange(2**(4-length)):
            val[(prefix[0] & ~(2**(4-length) -1)) + x] = True

    def prefixlen(self, ip):
        ip = sum(((int(x)/16,int(x)%16) for x in ip.split('.')), ())
        depth = 0
        val = self.prefixes
        if val == True: return depth
        if not val: return None
        for quartet in ip:
            depth += 4
            val = val.get(quartet)
            if val == True: return depth
            if not val: return None

    def __contains__(self, ip):
        ip = sum(((int(x)/16,int(x)%16) for x in ip.split('.')), ())
        val = self.prefixes
        if val == True: return True
        if not val: return False
        for quartet in ip:
            val = val.get(quartet)
            if val == True: return True
            if not val: return False

class AuthorizationError(AssertionError):
    pass
