from distutils.core import setup, Extension


setup ( name = 'FLVTOOLS',
        version = open('lib/__version__.py').readline().rstrip().split('=')[1].strip('"'),
        author = 'Kyle Vogt',
        author_email = 'kyle@justin.tv',
        description = 'Set of tools implementing rtmp and allowing manipulation of FLV files',
        package_dir = {'flvtools': 'lib'},
        packages = ['flvtools', 'flvtools.factories', 'flvtools.protocols', 'flvtools.rtmp'],
        data_files = [
            ('data', ['server_qa_test.flv']),
        ],
        scripts = ['bin/flvpuller.py', 'bin/flvpusher.py', 'bin/latency_test.py', 'bin/repair_flv.py', 'bin/concatenate.py', 'bin/sync_timestamps.py', 'bin/fix_timestamps.py']
       )
