/* jshint node:true */
'use strict';

module.exports = {
  extends: 'recommended',

  rules: {
    'bare-strings': {
        whitelist: ['(', ')', ',', '.', '&', '+', '-', '=', '*', '/', '#', '%', '!', '?', ':', '[', ']', '{', '}', '<', '>', '·', '|', '•', '—', ' '],
        globalAttributes: ['title'],
        elementAttributes: {
            'input': ['placeholder'],
            'img': ['alt']
        }
    },

    // Temporarily disable these rules for the ember-cli-template-lint v0.5.0 upgrade:
    //
    // * 'img-alt-attributes' violations should be fixed for accessibility concerns,
    //   but require alternative texts to be translated.
    'img-alt-attributes': false,

    // * 'invalid-interactive' violations require a deeper discussion on how to correctly
    //   use HTML elements for user interactions.
    'invalid-interactive': false
  },

  pending: [
    {'moduleId': 'web-client/components/bits/show-receipt/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/chat/chat-display/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/chat/message-line/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/chat/invitation-notification/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/chat/chat-rules/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/chat/twitch-chat-suggestions/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/front-page/header-bar/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-conversations/conversation-chat-display/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-conversations/list/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-friends-list/twitch-friend-recommended-list/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-friends-list/twitch-friend-request/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-friends-list/twitch-friend-search-result/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/components/twitch-friends-list/twitch-friend-settings-requests/template', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/pr/backpack-ticket-sm', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/application', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/bits-amendment', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/broadcast', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/channel/abuse', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/channel/post', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/channels-platform-selector', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/chat-right-column', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/commission-button', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/community-submission', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/countdown-timer', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/directory-featured-game', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/directory-following-none', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/following-column', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/highlighter-language-select', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/highlighter-set-range', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/host-preview', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/loading-more-spinner', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/notification-controls', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/offline-playlist-manager', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/panel-image-upload', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/stream-preview', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/components/twitch-player', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/create-landing', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/directory/csgo', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/manager/highlighter/share', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/manager/highlighter', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/net-payment-amendment', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/shared/following-games-onboard-modal', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/shared/load-more', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/shared/youtube-exporter', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/dashboards/subscription-dash/chat-perks', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/dashboards/subscription-dash/payments', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/dashboards/subscription-dash/subscriber-achievement', 'only': ['bare-strings']},
    {'moduleId': 'web-client/templates/dashboards/subscription-dash/teespring', 'only': ['bare-strings']}
  ]
};
