var path = require('path');
var fs = require('fs');

var I18N_CONFIG_FILE = './i18n/i18n.config.json';
var SMARTLING_CONFIG_FILE = './i18n/smartling.config.json'; 

module.exports = function(grunt) {

  if (!grunt.file.exists(I18N_CONFIG_FILE)) {
    grunt.fail.fatal('Confirm i18n.config.json exists');
  }

  var i18nConfig = grunt.file.readJSON(I18N_CONFIG_FILE);
  
  var smartlingConfig = {
    projectName: i18nConfig.projectName,
    apiBaseUrl: i18nConfig.apiBaseUrl
  };

  if (grunt.file.exists(SMARTLING_CONFIG_FILE)) { // dev overrides
    smartlingConfig = grunt.file.readJSON(SMARTLING_CONFIG_FILE);
  }
  
  grunt.loadNpmTasks('grunt-smartling-sdk-twitch');

  grunt.initConfig({
    retrieve: {
      options: {
        smartling: smartlingConfig,
        operation: {
          locale: 'en',
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    submit: {
      options: {
        smartling: smartlingConfig,
        i18n: i18nConfig,
        operation: {
          approved: false
        }
      },
      default: {
        options: {}
      }
    },

    update: {
      options: {
        smartling: smartlingConfig,
        operation: {
          locale: 'en',
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    'upload-source': {
      options: {
        smartling: smartlingConfig,
        i18n: i18nConfig,
        operation: {
          approved: false
        }
      },
      default: {
        options: {}
      }
    }
  });
};
