
# web-client

[![Build Status](https://jenkins.internal.justin.tv/job/web-client/badge/icon)](https://jenkins.internal.justin.tv/job/web-client/)

`web-client` is the [twitch.tv](https://www.twitch.tv/) frontend, written in
[Ember.js](http://emberjs.com/).

**Please note that master of web-client is automatically deployed to
production. This includes merged PRs and pushes from the console.** Visit
`#web-client` on Slack if you have any questions, concerns, or need
assistance.

## Prerequisites

* [Git](https://git-scm.com/)
  * `brew update`
  * `brew install git`
* [Node.js](https://nodejs.org/)
  * `brew tap homebrew/versions`
  * `brew install homebrew/versions/node6-lts`
* [Yarn](https://yarnpkg.com)
  * `brew update`
  * `brew install yarn`
* [Go](https://golang.org/) for building and running the versioned JS assets server, though it is not currently required for local development at the moment.
    * `brew install go --cross-compile-common`
    * `mkdir $HOME/go`
    * `export GOPATH=$HOME/go`
* `npm install -g bower`
* `npm install -g ember-cli`
* `brew install phantomjs`
* `brew install watchman`
* It is highly recommended that you install the [Ember Inspector](https://guides.emberjs.com/v2.9.0/ember-inspector/installation/).
* Developers should also follow the [Dev Environment Setup Docs](https://git-aws.internal.justin.tv/twitch/docs/blob/master/web/dev_environment_setup.md).
* (Optional: for local rails development) clone the [web/web repo](https://git-aws.internal.justin.tv/web/web)

## Installation

* `cd ~/twitch` whichever directory contains web is recommended
* `git clone git@git-aws.internal.justin.tv:web/web-client.git`
* `cd web-client`
* (Optional: for local rails development) `make link web=/path/to/web` (local [web/web repo](https://git-aws.internal.justin.tv/web/web)) generates the symlink for web (the default for the path to web is `../web` if you have the common configuration in which web is a sibling directory)
* `yarn install` installs `bower` and `npm` dependencies.
* `ember s` builds the app and starts up a livereload server at https://localhost.twitch.tv:4200 (See [Setting Up Localhost](https://git-aws.internal.justin.tv/twitch/docs/blob/master/web/dev_environment_setup.md#edit-hosts-file))

## Local SSL Setup (OSX Only)

  1. `make ssl` to generate self-signed SSL certificate

  2. When prompted provide your system password to install and trust the cert.

  Running ember server in SSL mode

  ```
  ember server
  ```

  To run in non-SSL mode use:

  ```
  ember server --no-ssl --proxy="http://www.twitch.tv"
  ```

## Development

* `yarn install` installs `bower` and `npm` dependencies.
* `ember s` to build the app and make it available at https://localhost.twitch.tv:4200
The server will watch your files for changes and automatically rebuild the app when they are detected.

### Updating packages

We are using `yarn` to manage our projects dependencies (see https://yarnpkg.com/ for info on the benefits over `npm`). This means there are a
few differences to updating dependencies that you may need to know.

* Updating a specific dependency: `yarn upgrade <package-name-here>`. This will update both `yarn.lock` and `package.json` to the newest version.
* Updating deps to newer versions: `yarn upgrade-interactive`.  This will provide a nice set of prompts for each outdated package in the project,
  and make updating both `package.json` and `yarn.lock` much easier.

### Helpful Scripts

* `yarn run clean` clears your bower cache as well as removing package directories and compiled/disted files.
This is most useful when changes were made to the app's `package.json` or `bower.json` and you'd like to install the new package versions.
* `npm run serve:chat` will build the sub-application for the chat popout. Once the initial build is completed, navigate to `http://localhost.twitch.tv:4200/some-channel-id/chat` in Safari to test.

### Stripping New Features from the build

Build new features without letting our users know what is on our roadmap.
We have a system that will remove modules from the `emberapp.js` then lazy load that feature to beta users.

More details [here](https://git-aws.internal.justin.tv/twitch/docs/blob/master/javascript/web-client/stripping-features-from-web-client.md)

### Linting

Linting is done via [ESLint](http://eslint.org). Run `make lint` to check your changes for linting errors.

### Testing

* install phantomjs globally using `yarn global add phantomjs-prebuilt`
* `yarn test` will run the tests using the phantomjs test runner. The output is a little noisy so search for 'not ok' to find test failures.
* `yarn test-chrome:server` will create a test server that will watch for changes and rerun tests when needed. You can see them in your browser by going to [localhost.twitch.tv:7357](http://localhost.twitch.tv:7357/).
* `yarn test-ci` will run phantom tests that mirror the exact conditions used in our CI server. Useful for debugging testing errors that can't be replicated using the above commands.

### web/web dependencies

* Certain pages that live in web/web embed ember components
    * autohost settings section on settings/channel
    * search side bar on settings and messages
    * search top bar on some dashboard tabs
* If you're making any changes that may affect global ember (e.g. global dependencies), run web/web against your changes to ensure ember still loads properly

### Smoke Tests (Smoca)
Assuming your branch is currently deployed on a staging environment:
* Go to the Smoca dashboard [page](http://smoca.internal.justin.tv/run)
* Select the correct parameters and hit "Start Build"

### Deployment

[See the guide on the wiki.][deployment-guide]

[deployment-guide]: https://git-aws.internal.justin.tv/twitch/docs/blob/master/javascript/web-client/deployment.md

### [Common Issues](https://git-aws.internal.justin.tv/twitch/docs/blob/master/javascript/web-client/common-issues.md)

## Further Reading

### Links

* [Frontend Engineering Reference](https://twitchtv.atlassian.net/wiki/display/ENG/Frontend+Engineering)
* [Web-Client Engineering Documentation](https://git-aws.internal.justin.tv/twitch/docs/tree/master/javascript/web-client)
* [Internationalization Guide](https://git-aws.internal.justin.tv/twitch/docs/blob/master/web/i18n/internationalization_pipeline.md)

### Reference

* [Ember](http://emberjs.com/guides/)
* [Ember CLI](http://ember-cli.com/)
* [ES6 Modules](http://eviltrout.com/2014/05/03/getting-started-with-es6.html)
* [Bower](https://github.com/bower/bower)
