import Adapter from 'ember-data/adapter';
import injectService from 'ember-service/inject';

const DEFAULT_API_VERSION = 4;

export default Adapter.extend({
  api: injectService(),
  apiVersion: DEFAULT_API_VERSION,

  // TODO: Remove, see https://git-aws.internal.justin.tv/web/web-client/issues/698
  shouldReloadAll() {
    return true;
  },

  _urlFor(id) {
    let url = this.get('apiUrl');
    return `${url}/${id}`;
  },

  query(store, type, query) {
    let url = this.get('apiUrl');
    return this.request(url, type, query);
  },

  findHasMany(store, snapshot, url) {
    return this.request(url);
  },

  request(url, type = 'get', query = {}, options = {}) {
    options.version = options.version || this.get('apiVersion');

    return this.get('api').request(type, url, query, options);
  },

  authRequest(url, type = 'get', query = {}, options = {}) {
    options.version = options.version || this.get('apiVersion');

    return this.get('api').authRequest(type, url, query, options);
  }
});
