import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';
import { withQueryParams } from 'web-client/utilities/url-params';
import { assert } from 'ember-metal/utils';

export const SORT_PERIOD_DAY = 'day';
export const SORT_PERIOD_WEEK = 'week';
export const SORT_PERIOD_MONTH = 'month';
export const SORT_PERIOD_ALL = 'all';
export const SORT_TRENDING = 'trending';

export const PERIOD_TYPES = [
  SORT_PERIOD_DAY,
  SORT_PERIOD_WEEK,
  SORT_PERIOD_MONTH,
  SORT_PERIOD_ALL
];

export default ApplicationAdapter.extend({
  api: injectService(),

  query(store, type, query) {
    assert("query expects a valid period if specified", !(query && query.period) || !PERIOD_TYPES.includes[query.period]);

    let url = withQueryParams(
      `/kraken/clips/top`,
      ['game', 'channel', 'cursor', 'limit', 'period', 'trending'],
      query
    );

    return this.get('api').request('get', url);
  }
});
