import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';

export default ApplicationAdapter.extend({
  api: injectService(),

  query(store, type, query) {
    return this.get('api').request('get', `/kraken/games/${query.game}/communities`, query);
  },

  queryRecord(store, type, query) {
    return this.get('api').request('get', `/kraken/games/${query.game}/communities/${query.community}`);
  },

  _post(store, type, snapshot) {
    let game = snapshot.attr('game');
    let payload = {
      game,
      name: snapshot.attr('name'),
      banner: snapshot.attr('banner'),
      thumbnail: snapshot.attr('thumbnail')
    };
    let token = snapshot.adapterOptions.token;
    let headers = { 'Authorization': `OAuth ${token}` };
    return this.get('api').request('post', `/kraken/games/${game}/communities`, payload, { headers });
  },

  updateRecord() {
    return this._post(...arguments);
  },

  createRecord() {
    return this._post(...arguments);
  }
});
