import Adapter from 'ember-data/adapter';
import injectService from 'ember-service/inject';

export default Adapter.extend({
  api: injectService(),

  createRecord (store, type, snapshot) {
    let channelId = snapshot.belongsTo('channel').attr('_id');
    let path = `/v5/channels/${channelId}/events`;

    // data to be mutated in the serializer
    let data = {};
    let serializer = store.serializerFor(type.modelName);
    serializer.serializeIntoHash(data, type, snapshot);

    return this.get('api').authRequest('post', path, JSON.stringify(data), {
      contentType: 'application/json',
      version: 5
    });
  },

  query (store, type, params) {
    let channelId = params.filter.channelId;
    let url = `/v5/channels/${ channelId }/events`;

    return this.get('api').authRequest('get', url);
  },

  deleteRecord (store, type, snapshot) {
    let eventId = snapshot.id;
    let url = `/v5/events/${ eventId }`;

    return this.get('api').authRequest('delete', url, { version: 5 });
  },

  updateRecord (store, type, snapshot) {
    let eventId = snapshot.id;
    let url = `/v5/events/${ eventId }`;

    // data to be mutated in the serializer
    let data = {};
    let serializer = store.serializerFor(type.modelName);
    serializer.serializeIntoHash(data, type, snapshot);

    return this.get('api').authRequest('put', url, JSON.stringify(data), {
      contentType: 'application/json',
      version: 5
    });
  }
});
