import Adapter from 'ember-data/adapter';
import injectService from 'ember-service/inject';

export default Adapter.extend({
  api: injectService(),

  findRecord(store, type, id/*, snapshot*/) {
    let url = '/api/friendships/users';
    return this.get('api').request('get', url, {ids: id}).then((userPayload) => {
      // Make this look like a kraken user
      userPayload.users.forEach((user) => {
        user._id = user.id;
        delete user.id;
      });
      return userPayload.users[0];
    });
  }
});
