import RSVP from 'rsvp';
import Adapter from 'ember-data/adapter';
import injectService from 'ember-service/inject';
import { presenceHost } from 'web-client/utilities/presence-util';

const DEFAULT_LIMIT = 10,
      DEFAULT_OFFSET = 0;

export default Adapter.extend({
  friendship: injectService('twitch-friends-list/backend/friendship'),
  ajax: injectService('twitch-friends-list/backend/ajax'),
  api: injectService(),
  globals: injectService(),

  // TODO: Remove, see https://git-aws.internal.justin.tv/web/web-client/issues/698
  shouldReloadAll() {
    return true;
  },

  queryUserInfo(store, type, params) {
    let ids = params.ids.join(',');
    return this.get('api').request('get', `/api/friendships/users?ids=${ids}`);
  },

  queryFriends() {
    return this.get('ajax').request(`${presenceHost}/v1/friends`);
  },

  queryFriendStatus(store, type, params) {
    return this.get('friendship').request(`/${params.login}`).then(response => {
      response.user_id = params.id;
      return response;
    });
  },

  queryUnfriend(store, type, params) {
    return this.get('friendship').request(`/${params.login}`, {
      type: 'DELETE'
    }).then(() => {
      return {
        action: 'unfriend',
        params: params
      };
    });
  },

  queryUnrecommend(store, type, params) {
    return this.get('ajax').request(`https://${this.get('globals.apiHostport')}/kraken/users/${params.login}/friends/recommended/${params.target}`, {
      type: 'DELETE'
    });
  },

  querySearch(store, type, params) {
    let limit = params.limit || DEFAULT_LIMIT,
        offset = params.offset || DEFAULT_OFFSET,
        q = params.q;

    return this.get('api').request('get', '/kraken/search/users', { q, limit, offset });
  },

  queryRecommended(store, type, params) {
    return this.get('ajax').request(`https://${this.get('globals.apiHostport')}/v4/users/${params.login}/friends/recommendations`);
  },

  queryBlock(store, type, params) {
    // NOTE: This endpoint is out of scope for friendship v1 and may not work
    return this.get('friendship').request(`/blocks/${params.login}`, {
      type: 'POST'
    }).then(() => {
      return { user_id: params.id };
    });
  },

  queryUnblock(store, type, params) {
    // NOTE: This endpoint is out of scope for friendship v1 and may not work
    return this.get('friendship').request(`/blocks/${params.login}`, {
      type: 'DELETE'
    }).then(() => {
      return { user_id: params.id };
    });
  },

  queryRecord(store, type, params) {
    switch (params.type) {
      case 'unfriend':
        return this.queryUnfriend(...arguments);
      case 'friend-status':
        return this.queryFriendStatus(...arguments);
      case 'block':
        return this.queryBlock(...arguments);
      case 'unblock':
        return this.queryUnblock(...arguments);
      case 'unrecommend':
        return this.queryUnrecommend(...arguments);
      default:
        return RSVP.reject(new Error(`${params.type} is not a valid query type`));
    }
  },

  query(store, type, params) {
    switch (params.type) {
      case 'user-info':
        return this.queryUserInfo(...arguments);
      case 'friends':
        return this.queryFriends(...arguments);
      case 'friend-status':
        return this.queryFriendStatus(...arguments);
      case 'search':
        return this.querySearch(...arguments);
      case 'recommended':
        return this.queryRecommended(...arguments);
      default:
        return RSVP.reject(new Error(`${params.type} is not a valid query type`));
    }
  }
});
