import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';

export default ApplicationAdapter.extend({
  api: injectService(),
  session: injectService(),

  queryRecord(store, type, query) {
    let game = encodeURIComponent(query.game);
    query.cache = Date.now(); // IE11 caches AJAX requests so we need to bust the cache
    delete query.game;

    let { isAuthenticated } = this.get('session');
    if (isAuthenticated) {
      return this.get('api').authRequest('get', `/v5/games/${game}/details/user`, query);
    }
    return this.get('api').request('get', `/v5/games/${game}/details`, query);
  }
});
