import Ember from 'ember';
import ApplicationAdapter from './application';
import omit from '../utilities/omit';

const { inject } = Ember;

// this.get('api').request('get', '/api/users/:login/follows/games');
// this.get('api').request('get', '/api/featured_games', {limit: this.limit, offset: this.get('content.length')});
// this.get('api').request('get', '/api/users/:login/follows/games/isFollowing', {name: this.get('game')});
// this.get('api').request('get', '/api/users/:login/follows/games/live');
// this.get('api').request('get', 'games/top', {limit: limit, offset: this.get('content.length')});

const KINDS = {
  query: {
    top: 'games/top',
    featured: '/api/featured_games',
    followed: '/api/users/:login/follows/games',
    followedLive: '/api/users/:login/follows/games/live'
  },
  queryRecord: {
    follow: {url: '/api/users/:login/follows/games/follow', method: 'put'},
    unfollow: {url: '/api/users/:login/follows/games/unfollow', method: 'del'}
  }
};

export default ApplicationAdapter.extend({
  api: inject.service(),

  query(store, type, query) {
    if (KINDS.query[query.kind]) {
      let url = KINDS.query[query.kind];
      query = omit(query, 'kind');
      return this.get('api').request('get', url, query);
    }
  },

  queryRecord(store, type, query) {
    let kind = KINDS.queryRecord[query.kind];

    if (kind) {
      query = omit(query, 'kind');
      return this.get('api').request(kind.method, kind.url, query);
    }
  },

  findRecord(store, type, id) {
    return this.get('api').request('get', 'search/games', { q: id, type: 'suggest' })
      .then(result => {
        if (result.games &&
            result.games.length > 0 &&
            result.games.map(game => game.name.toLowerCase()).includes(id.toLowerCase())) {

          return result;
        }

        throw new Error();
      });
  }
});
