import VideoAdapter from 'web-client/adapters/video';
import { withQueryParams } from 'web-client/utilities/url-params';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default VideoAdapter.extend({
  apiVersion: 4,

  createRecord(store, type, snapshot) {
    let serializer = store.serializerFor(type.modelName);
    let channelName = snapshot.attr('channelName');
    let url = `/kraken/videos?channel_id=${channelName}`;
    let data = serializer.serializeForCreate(snapshot);

    return this.request(url, 'post', data);
  },

  query(store, type, query) {
    let url = withQueryParams(
      `/api/channels/${query.channelName}/video_manager/uploads`,
      ['status', 'limit', 'offset'],
      query
    );

    return this.request(url);
  },

  findRecord(store, type, id) {
    return this.request(`/kraken/videos/v${normalizeVideoId(id)}`);
  }
});
