import Ember from 'ember';
import ApplicationAdapter from './application';

const { inject } = Ember;

export default ApplicationAdapter.extend({
  api: inject.service(),

  findRecord(store, id, options) {
    let url = `/api/playlists/channels/${options}`;
    return this.get('api').request('get', url);
  },

  updateRecord(store, type, snapshot) {
    let channelId = snapshot.id;
    let payload = {
      enabled: snapshot.record.get('enabled')
    };
    let options = {
      channelId,
      contentType: 'application/json; charset=UTF-8',
      processData: false
    };

    return this.get('api').request('put', `/api/playlists/channels/${channelId}`, JSON.stringify(payload), options);
  }
});
