import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';

export default ApplicationAdapter.extend({
  api: injectService(),
  apiVersion: 5,
  session: injectService(),

  shouldReloadRecord() {
    return false;
  },

  shouldBackgroundReloadRecord() {
    return false;
  },

  findRecord(store, type, id) {
    // it only makes sense to get the summary for the self user
    if (id !== 'user') {
      throw new Error('only permitted id is \'user\'');
    }

    let userId = this.get('session.userData.id');
    let url = `users/${userId}/notifications/onsite/summary`;
    return this.authRequest(url);
  }
});
