import PresenceAdapter from 'web-client/adapters/presence';

export default PresenceAdapter.extend({
  /**
   * Build the url for updating records
   * @param id The record's id
   * @param modelName The type of model
   * @returns {*} Url to hit for the request
   */
  urlForUpdateRecord(id, modelName) {
    return this._buildURL(modelName.replace('presence-', '')); // Throw away the id, it's not persisted
  },
  /**
   * Build the url for querying records
   * @param query The query to specify record(s)
   * @param modelName The type of model
   * @returns {*} Url to hit for the request
     */
  urlForQueryRecord(query, modelName) {
    return this._buildURL(modelName.replace('presence-', ''));
  }
});
