import RESTAdapter from 'ember-data/adapters/rest';
import injectService from 'ember-service/inject';
import { isPresent } from 'ember-utils';
import { presenceHost } from 'web-client/utilities/presence-util';

export default RESTAdapter.extend({
  ajaxService: injectService('twitch-presence/backend/ajax'),
  host: presenceHost,
  namespace: 'v1',

  // TODO: Remove, see https://git-aws.internal.justin.tv/web/web-client/issues/698
  shouldReloadAll() {
    return true;
  },

  /**
   * Triggers a request through the ajax service
   *
   * Note: This is a private method being overridden to use the `ajaxService` because
   * I couldn't quite get the default Ember-Data `ajax` call to authenticate properly.
   * @param url The url for the request
   * @param type The type of request
   * @param options Options for the request
   * @returns {*} Promise for the AJAX request
     */
  ajax(url, type, options) {
    if (isPresent(type)) { // Newer versions of `request` and `$.ajax` don't take 3 params, so we need to put `type` in `options`
      options.type = type;
    }
    return this.get('ajaxService')._request(url, options);
  }
});
