import JSONAPIAdapter from "ember-data/adapters/json-api";
import injectService from 'ember-service/inject';

export default JSONAPIAdapter.extend({
  api: injectService(),

  // Sets the host for all non-deleteRecord requests on this adapter
  host: '//rechat.twitch.tv',

  // TODO: Remove, see https://git-aws.internal.justin.tv/web/web-client/issues/698
  shouldReloadAll() {
    return true;
  },

  deleteRecord(store, type, snapshot) {
    let id = snapshot.id;
    let roomId = snapshot.attr('tags')['room-id'];
    let url = `/api/rechat/delete/${id}?channel_id=${roomId}`;

    return this.get('api').request('del', url);
  }
});
