import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';

export default ApplicationAdapter.extend({
  api: injectService(),

  query(store, type, query={}) {
    let api = this.get('api');

    return api.request('get', '/kraken/streams/recommended', query).catch((error) => {
      // Treat api call errors as "no recommendations available"
      if (typeof error === 'object' && error.status >= 400) {
        return { recommended_streams: [] };
      }

      throw error;
    });
  }
});
