import injectService from 'ember-service/inject';
import Adapter from 'ember-data/adapter';

const BASE_URL = '/v1/threads';

export default Adapter.extend({
  imApi: injectService(),

  // TODO: Remove, see https://git-aws.internal.justin.tv/web/web-client/issues/698
  shouldReloadAll() {
    return true;
  },

  findAll() {
    return this.get('imApi').makeRequest('GET', BASE_URL);
  },

  updateRecord(store, type, snapshot) {
    return this.get('imApi').makeRequest('POST', `${BASE_URL}/${snapshot.id}`, snapshot.serialize());
  },

  findHasMany(store, snapshot, url) {
    return this.get('imApi').makeRequest('GET', url);
  },

  findRecord(store, type, id) {
    return this.get('imApi').makeRequest('GET', `${BASE_URL}/${id}`);
  },

  query(store, type, query) {
    return this.get('imApi').makeRequest(query.method || 'GET', BASE_URL, query.queryParams);
  }
});
