import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';
import env from 'web-client/config/environment';


const KINDS = {
  query: {
    top: 'communities/top',
    creative: 'Creative'
  }
};

export default ApplicationAdapter.extend({
  communities: injectService(),
  api: injectService(),

  query(store, type, query) {
    if(query.game === KINDS.query.creative) {
      return this.get('api').request('get', '/api/aggregates/Creative', {}, {host: env.creative.aggregator.host}).then(result => result.aggregate.communities);
    }
    if(KINDS.query[query.kind]) {
      return this.get('communities').getTopCommunities(query.limit, query.cursor);
    }
  }
});
