import ApplicationAdapter from './application';
import injectService from 'ember-service/inject';

export default ApplicationAdapter.extend({
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService(),

  shouldReloadRecord() {
    return false;
  },

  _urlForUser(id) {
    let login = this.get('login');
    if (id === login.get('userData.login')) {
      // Authenticated endpoint that returns a Kraken user object with additional properties: email, notification settings, and partnered status.
      return 'user';
    }

    return `users/${id}`;
  },

  findRecord(store, type, id) {
    let url = this._urlForUser(id);
    return this.request(url);
  },

  updateRecord(store, type, snapshot) {
    let payload = snapshot.attributes();
    let id = snapshot.id;
    return this.get('api').request('put', `/api/users/${snapshot.id}`, payload).then(response => {
      response.name = id;
      return response;
    });
  },

  query(store, type, params) {
    if (params.url) {
      return this.request(params.url);
    }

    return this._super(...arguments);
  }
});
