import ApplicationAdapter from 'web-client/adapters/application';
import { withQueryParams } from 'web-client/utilities/url-params';

export const COLLECTION_BASE = '/kraken/collections';
const CHANNEL_QUERY_BASE = '/kraken/channels';

export default ApplicationAdapter.extend({
  apiVersion: 5,

  findRecord(store, type, id) {
    return this.request(`${COLLECTION_BASE}/${id}`);
  },

  query(store, type, query) {
    let userId = query.userId;
    let url = withQueryParams(
      `${CHANNEL_QUERY_BASE}/${userId}/collections`,
      ['limit', 'cursor'],
      query
    );

    return this.request(url);
  },

  createRecord(store, type, snapshot) {
    let data = this.serialize(snapshot);
    let userId = snapshot.record.owner_id;
    return this.authRequest(`${CHANNEL_QUERY_BASE}/${userId}/collections`, 'post', data);
  },

  updateRecord(store, type, snapshot) {
    let data = this.serialize(snapshot);
    return this.authRequest(`${COLLECTION_BASE}/${snapshot.id}`, 'put', data);
  },

  findHasMany(store, snapshot, url) {
    return this.authRequest(url);
  },
  deleteRecord(store, type, snapshot) {
    return this.authRequest(
      `${COLLECTION_BASE}/${snapshot.id}`,
      'delete'
    );
  }
});
