import ApplicationAdapter from 'web-client/adapters/application';
import injectService from 'ember-service/inject';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default ApplicationAdapter.extend({
  api: injectService(),

  buildPath(id) {
    return `/kraken/vods/${id}/analytics/lifetime`;
  },

  findRecord(store, type, id) {
    let path = this.buildPath(normalizeVideoId(id));
    return this.get('api').authRequest('get', path, {}, { version: 5 });
  }
});
