import ApplicationAdapter from 'web-client/adapters/application';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default ApplicationAdapter.extend({
  apiVersion: 5,

  findRecord(store, type, id) {
    return this.request(`/kraken/videos/v${normalizeVideoId(id)}`);
  },

  deleteRecord(store, type, { id, record }) {
    if (record.willDelete) {
      record.willDelete();
    }

    let url = `/kraken/videos/${normalizeVideoId(id)}`;

    return this.request(url, 'delete');
  },

  updateRecord(store, type, snapshot) {
    let serializer = store.serializerFor(type.modelName);
    let videoId = snapshot.id;
    let url = `/api/vods/${normalizeVideoId(videoId)}`;
    let data = serializer.serializeForUpdate(snapshot);

    return this.request(url, 'put', data);
  }
});
