/* globals Rollbar, SiteOptions, NotificationsTracker, Twitch */
/* eslint-disable no-console */

import Ember from 'ember';
import Resolver from './resolver';
import loadInitializers from 'ember-load-initializers';
import config from './config/environment';
import { setShouldAssertPassive } from 'web-client/mixins/context-bound-event-listeners';
import Application from 'ember-application';

// Side effect imports to reopen Ember base classes
import './ext/array';
import './ext/datepicker-moment';
import './ext/patch-route-render';
import './ext/component';
import './ext/link-to';
import './ext/service';
import './ext/route';

if (config.environment !== 'production') {
  setShouldAssertPassive(true);
  window.RSVP.on('error', function(reason, label) {
   if (label) {
     console.error(label);
   }
   console.assert(false, reason);
  });
}

Ember.MODEL_FACTORY_INJECTIONS = true;

let App = Application.extend({
  modulePrefix: config.modulePrefix,
  podModulePrefix: config.podModulePrefix,
  Resolver
});

config.rollbar.payload.environment = SiteOptions.deploy_flavor;
Rollbar.configure(config.rollbar);

loadInitializers(App, config.modulePrefix);

// Don't show notifications when embedding the Ember app in a static page
if (!SiteOptions.embedEmberComponents) {
  NotificationsTracker.startTracking();
}

Twitch.asyncAds.enable();

// Ensure a unique device_id has been generated and stored
Twitch.idsForMixpanel.getOrCreateUniqueId();

// Benchmark how long it took for the ember App to be booted.
// This gets run in embed, so make sure that we have benchmark available.
if (Twitch && Twitch.benchmark) {
  Twitch.benchmark.track('app_booted');
}

export default App;
