/* globals Twitch */

import computed from 'ember-computed';
import SupportButton from 'web-client/components/backpack/support-button/component';

export default SupportButton.extend({
  name: 'paymentInfo',

  priceLabel: computed('ticket.product.{recurring,period,interval_number}', 'ticket.purchase_profile.paid_on', function() {
    if (!this.get('ticket.product.recurring')) {
      return 'One-Time Payment';
    }

    let date = new Date(this.get('ticket.purchase_profile.paid_on'));
    if (this.get('ticket.product.period') === "Month") {
      date.setMonth(date.getMonth() + this.get('ticket.product.interval_number'));
    }

    return `Recurring Payment Date: ${date.toString('dd/MM')}`;
  }),

  // doNotRenewLink, cancelAndRefundLink, and cancelLink should be generated behind the api
  doNotRenewLink: computed('ticket.product.short_name', function() {
    let shortName = this.get('ticket.product.short_name');

    return Twitch.uri.productDoNotRenew(shortName);
  }),

  cancelAndRefundLink: computed('ticket.product.short_name', function() {
    let shortName = this.get('ticket.product.short_name');

    return Twitch.uri.productCancelAndRefund(shortName);
  }),

  cancelLink: computed('ticket.product.short_name', function() {
    let shortName = this.get('ticket.product.short_name');

    return Twitch.uri.productCancel(shortName);
  })
});
