import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['js-bits-ads-reward'],
  bitsRoom: injectService(),

  bitsReward: computed.readOnly('bitsRoom.adReward'),

  actions: {
    startCheering() {
      this.get('bitsRoom').forceLoadBalance();
      this.get('bitsRoom').reloadTooltip();
    },
    close() {
      this.get('bitsRoom').forceLoadBalance();
      this.get('bitsRoom').dismissTooltip();
    }
  }
});
