import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import run from 'ember-runloop';

const SPOTLIGHT_DELAY = 100;
const REMOVE_SPOTLIGHT_DELAY = 400;

export default Component.extend({
  classNames: ['js-bits-animated-emote-landing'],

  bits: injectService(),
  bitsRoom: injectService(),
  tracking: injectService(),

  isShowingEmoteTiers: false,
  clickedShowTutorial: false,
  isSpotlighting: false,
  spotlightedPrefix: null,
  spotlightedValue: null,

  selectedPrefix: computed.alias('bitsRoom.selectedAnimatedEmotePrefix'),
  hasCheerMessage: computed.readOnly('bitsRoom.isCheerMessage'),
  noCheerMessage: computed.not('hasCheerMessage'),

  isShowingTutorial: computed('clickedShowTutorial', 'noCheerMessage', function () {
    return this.get('noCheerMessage') && this.get('clickedShowTutorial');
  }),

  init() {
    this._super(...arguments);

    this._spotlightTask = null;
    this._removeSpotlightTask = null;
  },

  actions: {
    close() {
      this.get('bitsRoom').dismissTooltip();
    },

    showTutorial() {
      this.set('clickedShowTutorial', true);
    },

    hideTutorial() {
      this.set('clickedShowTutorial', false);
    },

    spotlightEmote(prefix, id) {
      run.cancel(this._removeSpotlightTask);

      this._spotlightTask = this.runTask(() => {
        this.set('spotlightedPrefix', prefix);
        this.set('spotlightedValue', id);
        this.set('isSpotlighting', true);
        this.get('tracking').trackBitsCardInteractions('emote_preview', this.get('session.userData.login'), this.get('bits.balance'), prefix, id);
      }, SPOTLIGHT_DELAY);
    },

    removeSpotlight() {
      run.cancel(this._spotlightTask);

      this._removeSpotlightTask = this.runTask(this._removeSpotlightState, REMOVE_SPOTLIGHT_DELAY);
    },

    showEmoteTiers(prefix) {
      this._removeSpotlightState();
      this.set('selectedPrefix', prefix);
      this.set('isShowingEmoteTiers', true);
    },

    hideEmoteTiers() {
      this.set('selectedPrefix', '');
      this.set('isShowingEmoteTiers', false);
    },

    appendToChatMessage(prefix, id){
      let appendedCheer = `${prefix}${id}`;
      this.get('bitsRoom').appendToChatMessage(appendedCheer);
    }
  },

  _removeSpotlightState() {
    this.set('spotlightedPrefix', null);
    this.set('spotlightedValue', null);
    this.set('isSpotlighting', false);
  }
});
