import Ember from 'ember';
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

const { compare } = Ember;

export default Component.extend({
  tagName: 'ul',
  classNames: ['js-bits-animated-emote-selector', 'cheermote-selector', 'flex', 'flex--nowrap', 'flex--horizontalCenter'],

  bitsEmotes: injectService(),

  prefixes: computed('bitsEmotes.isLoaded', 'bitsEmotes.prefixes', function () {
    if (!this.get('bitsEmotes.isLoaded')) {
      return [];
    }

    let prefixes = this.get('bitsEmotes.prefixes') || [];

    // TODO: should be determined by a flag (this is a hack for staff beta)
    let hiddenPrefixes = ['Muxy', 'Streamlabs', 'tww'];

    return prefixes.filter((prefix) => {
      return !hiddenPrefixes.includes(prefix);
    }).sort((a, b) => {
      // ensure that 'Cheer' is displayed first
      if (a === CHEER_PREFIX) {
        return -1;
      }

      // otherwise, alphabetize
      return compare(a, b);
    });
  }),

  actions: {
    mouseEnterEmote(prefix) {
      this.sendAction('mouseEnterEmote', prefix);
    },
    mouseLeaveEmote() {
      this.sendAction('mouseLeaveEmote');
    },
    clickEmote(prefix) {
      this.sendAction('clickEmote', prefix);
    }
  }
});
