import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  tagName: 'ul',
  classNames: ['js-bits-animated-emote-tiers', 'cheermote-selector', 'flex', 'flex--nowrap', 'flex--horizontalCenter'],

  bitsRoom: injectService(),

  selectedEmote: computed.alias('bitsRoom.selectedAnimatedEmote'),
  selectedPrefix: computed.alias('bitsRoom.selectedAnimatedEmotePrefix'),

  actions: {
    mouseEnterEmote(prefix, id) {
      this.sendAction('mouseEnterEmote', prefix, id);
    },
    mouseLeaveEmote() {
      this.sendAction('mouseLeaveEmote');
    },
    clickEmote(prefix, id) {
      this.sendAction('clickEmote', prefix, id);
    }
  }
});
