import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { ASYNC_ERRORS } from 'web-client/helpers/bits-string';

/* Response bodies from Payday on failures -> Error shown to user */
const STATUS_TO_ERROR = ASYNC_ERRORS || {};

export default Component.extend({
  classNames: ['js-bits-async-error'],
  bitsRoom: injectService(),
  status: computed.readOnly('bitsRoom.bitsAsyncErrorStatus'),
  fallbackMessage: computed.readOnly('bitsRoom.bitsAsyncErrorMessage'),

  errorMessage: computed('status', 'fallbackMessage', function () {
    let fallbackMessage = "Have no fear, your Bits inventory is safe! The ability to Cheer will return shortly.";
    let errorMessage = STATUS_TO_ERROR[this.get('status')];

    return errorMessage ? errorMessage : fallbackMessage;
  }),

  click() {
    this.get('bitsRoom').dismissTooltip();
  }
});
