import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  classNames: ['bits-emotes'],
  bitsEmotes: injectService(),

  amount: 0,

  availableTiers: computed('bitsEmotes.isLoaded', 'amount', function () {
    if (!this.get('bitsEmotes.isLoaded')) {
      return [];
    }

    let amount = this.get('amount');
    let tiers = this.get('bitsEmotes').getTiers(CHEER_PREFIX);

    return tiers.filter((value) => {
      return value <= amount;
    });
  })
});
