/* globals onPopoutClose */

import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['js-bits-bits-products'],
  session: injectService(),
  tracking: injectService(),
  bitsRoom: injectService(),

  minBits: computed.readOnly('bitsRoom.minimumBits'),
  balance: computed.readOnly('bitsRoom.balance'),
  products: computed.readOnly('bitsRoom.purchaseProducts'),
  channelName: computed.readOnly('bitsRoom.channelDisplayName'),

  didInsertElement() {
    this._super(...arguments);

    this.$('.scroll').TrackpadScrollEmulator({
      wrapContent: false,
      scrollbarHideStrategy: 'rightAndBottom'
    });
  },

  actions: {
    close() {
      this.get('bitsRoom').dismissBuyMenu();
    },

    buy(asin, quantity, balance) {
      let action = `buy_${quantity}`;
      this.get('tracking').trackBitsCardInteractions(action, this.get('session.userData.login'), balance);

      let productsPopout = window.open(`/products/bits/${asin}`, 'Twitch', 'width=1024,height=600,scrollbars=yes');
      productsPopout.focus();
      onPopoutClose(productsPopout, () => {
        this.get('bitsRoom').forceLoadBalance();
      });

      this.get('bitsRoom').dismissBuyMenu();
    }
  }
});
