import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { BITS_URL } from 'web-client/utilities/urls/static-cdn';
import { CHEERMOTE_BG_DARK, CHEERMOTE_BG_LIGHT } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  classNames: ['js-bits-cheering-tutorial'],

  bitsRoom: injectService(),
  bitsEmotes: injectService(),

  channelName: computed.readOnly('bitsRoom.channelDisplayName'),

  tutorialImgUrl: computed('bitsEmotes.isDarkChat', function () {
    let emoteBg = this.get('bitsEmotes.isDarkChat') ? CHEERMOTE_BG_DARK : CHEERMOTE_BG_LIGHT;

    return `${BITS_URL}/${emoteBg}/animated/1/cheertutorial.gif`;
  })
});
