import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  classNames: ['js-bits-cheermote-spotlight', 'cheermote-spotlight'],

  bitsRoom: injectService(),

  prefix: CHEER_PREFIX,
  useCurrentCheer: false,
  cheermoteValue: null,

  channelName: computed.readOnly('bitsRoom.channelDisplayName'),
  hasCurrentCheer: computed.readOnly('bitsRoom.isCheerMessage'),

  isCheerAboveMax: computed.readOnly('bitsRoom.isCheerAboveMax'),
  isMaxMessageLengthExceeded: computed.readOnly('bitsRoom.isMaxMessageLengthExceeded'),
  isCheerZero: computed.readOnly('bitsRoom.isCheerZero'),
  showError: computed.or('isCheerAboveMax', 'isMaxMessageLengthExceeded', 'isCheerZero'),

  isCheerBelowMinEmote: computed.readOnly('bitsRoom.isCheerBelowMinEmote'),
  isCheerBelowMinimum: computed.readOnly('bitsRoom.isCheerBelowMinimum'),
  hideCurrentCheermote: computed.or('showError', 'isCheerBelowMinEmote', 'isCheerBelowMinimum'),
  showCurrentCheermote: computed.not('hideCurrentCheermote'),

  isBalanceExceeded: computed.readOnly('bitsRoom.isBalanceExceeded'),
  requiredBalance: computed.readOnly('bitsRoom.balanceExceededAmount'),

  currentCheerPrefix: computed.readOnly('bitsRoom.prefix'),
  currentCheerAmount: computed.readOnly('bitsRoom.totalBitsInMessage'),
  showCombinedCheerAmount: computed.and('showCurrentCheermote', 'bitsRoom.shouldShowBitsTotal'),

  minBitsEmote: computed.readOnly('bitsRoom.minimumBitsEmote'),
  numBitsToMinimum: computed.readOnly('bitsRoom.numBitsToMinimum'),
  numBitsToPinMinimum: computed.readOnly('bitsRoom.numBitsToPinMinimum'),
  showBitsToMinimumPinned: computed.gt('numBitsToPinMinimum', 0),

  hasValue: computed.notEmpty('cheermoteValue')
});
