import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { htmlSafe } from 'ember-string';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  tagName: 'strong',
  classNames: ['js-bits-emote-amount'],
  attributeBindings: ['style'],

  // defaults
  amount: 0,
  prefix: CHEER_PREFIX,
  asRgb: false,

  bitsEmotes: injectService(),

  style: computed('bitsEmotes.isLoaded', 'amount', 'prefix', 'asRgb', function () {
    if (!this.get('bitsEmotes.isLoaded')) {
      return;
    }

    let bitsEmotes = this.get('bitsEmotes');

    let amount = this.get('amount');
    let prefix = this.get('prefix');
    let asRgb = this.get('asRgb');

    let hexColor = bitsEmotes.getTierColor(amount, prefix);
    let color = asRgb ? this._hexToRgb(hexColor) : hexColor;
    return htmlSafe(`color:${color}`);
  }),

  _hexToRgb(hexString = '') {
    hexString = hexString[0] === '#' ? hexString.slice(1) : hexString;
    if (hexString.length < 6) {
      return;
    }

    let r = parseInt(hexString.slice(0, 2), 16);
    let g = parseInt(hexString.slice(2, 4), 16);
    let b = parseInt(hexString.slice(4, 6), 16);
    return [r, g, b].join(', ');
  }
});
