import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

export default Component.extend({
  tagName: 'img',
  classNames: ['js-bits-emote-image'],
  attributeBindings: ['src', 'srcset', 'data-test-selector', 'alt'],

  // defaults
  amount: 0,
  prefix: CHEER_PREFIX,
  useDarkAssetsOverride: null,
  useStaticAssets: false,
  size: 1,
  includeSrcSet: false,

  bitsEmotes: injectService(),

  srcAttrs: computed('bitsEmotes.isLoaded', 'bitsEmotes.isDarkChat', 'amount', 'prefix', 'useDarkAssetsOverride', 'useStaticAssets', 'size', 'includeSrcSet', function () {
    if (!this.get('bitsEmotes.isLoaded')) {
      return;
    }

    let bitsEmotes = this.get('bitsEmotes');

    let amount = this.get('amount');
    let prefix = this.get('prefix');
    let useDarkAssets = this.get('useDarkAssetsOverride') === null ? this.get('bitsEmotes.isDarkChat') : this.get('useDarkAssetsOverride');
    let useStaticAssets = this.get('useStaticAssets');
    let size = this.get('size');

    let attrs = {
      src: bitsEmotes.getImageSrc(amount, prefix, useDarkAssets, useStaticAssets, size)
    };

    if (this.get('includeSrcSet')) {
      attrs.srcSet = bitsEmotes.getImageSrcSet(amount, prefix, useDarkAssets, useStaticAssets, size);
    }
    return attrs;
  }),

  src: computed.readOnly('srcAttrs.src'),
  srcset: computed.readOnly('srcAttrs.srcSet')
});
