import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['js-bits-emote-tiers-intro'],

  bitsRoom: injectService(),
  bitsPinnedCheers: injectService(),

  minBits: computed.readOnly('bitsRoom.minimumBits'),
  minBitsPinned: computed.readOnly('bitsPinnedCheers.channelMinimum'),
  showMinBits: computed.gt('minBits', 1),
  showMinBitsPinned: computed.readOnly('bitsRoom.showMinBitsPinned'),

  emoteTiersPadding: computed('showMinBits', 'showMinBitsPinned', function () {
    let showMinBits = this.get('showMinBits');
    let showMinBitsPinned = this.get('showMinBitsPinned');

    if (showMinBits && showMinBitsPinned) {
      return 'pd-t-5';
    } else if (showMinBits || showMinBitsPinned) {
      return 'pd-t-6';
    }
    return 'pd-t-8';
  })
});
