import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

/*
  Button that toggles bits-tooltip
  Input:
    Action:
      * toggleBitsHelper: action called when clicked (presumably to toggle tooltip visibility)
*/
export default Component.extend({
  bitsRoom: injectService(),
  tagName: 'a',
  classNames: ['bits-helper-toggle bits__toggle js-bits-toggle'],
  classNameBindings: ['isShowingPromo:bits-helper-toggle--promo'],
  isTooltipOpen: computed.not('bitsRoom.isTooltipHidden'),

  click() {
    this.get('bitsRoom').toggleTooltip();
  }
});
