/* globals Twitch */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { BITS_URL } from 'web-client/utilities/urls/static-cdn';

const IMG_LEFT_URL = `${BITS_URL}/light/static/1/adspromoleft.png`;
const IMG_RIGHT_URL = `${BITS_URL}/light/static/1/adspromoright.png`;

export default Component.extend({
  classNames: ['js-bits-intro-promo-ads'],
  bitsRoom: injectService(),
  tracking: injectService(),
  session: injectService(),
  imgLeftUrl: IMG_LEFT_URL,
  imgRightUrl: IMG_RIGHT_URL,

  channelId: computed.readOnly('bitsRoom.channelId'),
  channelName: computed.readOnly('bitsRoom.channelName'),

  init() {
    this._super(...arguments);
    this._trackPromoEvent('seen');
  },

  actions: {
      getBits() {
        this.get('bitsRoom').completeAdsFTUE();
        this._trackPromoEvent('get_bits');
      },

      close() {
        this.get('bitsRoom').dismissAdsFTUE();
        this._trackPromoEvent('close');
      }
  },

  _trackPromoEvent(action) {
    let session = this.get('session');
    let login = '';
    let loginId = '';

    if (session.isAuthenticated && session.userData) {
      login = session.userData.name;
      loginId = session.userData.id;
    }

    let eventData = {
      client_time: new Date().getTime(),
      device_id: Twitch.idsForMixpanel.getOrCreateUniqueId(),
      login: login,
      login_id: loginId,
      channel: this.get('channelName'),
      channel_id: this.get('channelId'),
      action: action
    };

    this.get('tracking').trackEvent({
      event: 'bits_user_onboarding_ads',
      data: eventData
    });
  }
});
