import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  classNames: ['js-bits-inventory-footer'],
  bits: injectService(),
  bitsRoom: injectService(),
  balance: computed.readOnly('bitsRoom.balance'),
  minBits: computed.readOnly('bitsRoom.minimumBits'),

  // Properties passed in
  channelTotal: computed.readOnly('bitsRoom.channelTotal'),
  channelThresholds: computed.readOnly('bitsRoom.enabledBadgeTiers'),
  highestBitsBadge: computed.readOnly('bitsRoom.highestBitsBadge'),
  bitsBadges: computed.readOnly('bitsRoom.globalBadges'),

  // Own properties:
  reachedMaxBadge: false,
  nextBadgeThreshold: 0,
  nextBadgeOffset: '0px',
  distanceToNextBadge: 0,

  badgeProgessEnabled: computed('channelThresholds', 'highestBitsBadge', function () {
    let thresholds = this.get('channelThresholds');

    if (thresholds === undefined || thresholds.length === 0) {
      return false;
    }

    // special casing if the only badge turned on is the grey badge, and you haven't gotten it
    if (thresholds.length === 1 && thresholds[0] === 1 && this.get('highestBitsBadge') === 0) {
      return false;
    }

    return true;
  }),

  currentBadge: computed('bitsBadges.bits.versions', 'highestBitsBadge', function () {
    let badgeVersions = this.get('bitsBadges.bits.versions');

    if (this.get('highestBitsBadge') === 0 || this.get('highestBitsBadge') === undefined) {
      return null;
    }

    let badgeVersion = badgeVersions[this.get('highestBitsBadge')];
    return badgeVersion.image_url_1x;
  }),

  nextBadge: computed('bitsBadges.bits.versions', 'highestBitsBadge', 'channelThresholds', function() {
    this.set('reachedMaxBadge', false);

    let badgeVersions = this.get('bitsBadges.bits.versions');
    this.set('nextBadgeThreshold', 0);

    let thresholds = this.get('channelThresholds');
    for (let x = 0; x < thresholds.length; x++) {
      let threshold = thresholds[x];

      // special case and remove reference to the grey badge in the 'next badge' slot
      if (threshold > this.get('highestBitsBadge') && threshold !== 1) {
        this.set('nextBadgeThreshold', threshold);
        break;
      }
    }

    if (this.get('nextBadgeThreshold') === 0) {
      this.set('reachedMaxBadge', true);
      return null;
    }

    let badgeVersion = badgeVersions[this.get('nextBadgeThreshold')];
    return badgeVersion.image_url_1x;
  }),

  nextBadgeProgress: computed('reachedMaxBadge', 'nextBadgeThreshold', 'channelTotal', 'highestBitsBadge', function() {
    if (this.get('reachedMaxBadge')) {
      return '0px';
    }

    let distanceToBadge = Math.max(this.get('nextBadgeThreshold') - this.get('channelTotal'), 0);
    let totalDistanceForBadge = this.get('nextBadgeThreshold') - this.get('highestBitsBadge');

    let BADGE_WIDTH_PX = 18;

    let badgeProgress = ((distanceToBadge * BADGE_WIDTH_PX) / totalDistanceForBadge);
    let nextBadgeOff = Math.max((BADGE_WIDTH_PX - badgeProgress), 0);
    this.set('nextBadgeOffset',  `${nextBadgeOff}px`);
    this.set('distanceToNextBadge', distanceToBadge);

    return `${badgeProgress}px`;
  }),

  nextBadgeOverlayStyle: computed('nextBadgeProgress', 'nextBadgeOffset', function () {
    let width = this.get('nextBadgeProgress');
    let left = this.get('nextBadgeOffset');

    return htmlSafe(`width: ${ width }; left: ${ left };`);
  }),

  actions: {
    openBuyMenu() {
      this.get('bitsRoom').openBuyMenu();
    }
  }
});
