/* global i18n */

import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { PINNED_CHEER_TYPES } from 'web-client/utilities/bits/constants-config';

const SAVE_SUCCESS = i18n('Your bits settings have been successfully saved. It may take a few minutes for your settings to take effect.');
const SAVE_ERROR = i18n('There was a problem updating your new settings. Please try again.');
const RESET_SUCCESS = i18n('Your Top Cheer has been successfully reset.');
const RESET_ERROR = i18n('There was a problem resetting your Top Cheer. Please try again.');
const INVALID_ERROR = i18n('The Recent Cheer timer must not be 0 if Top Cheer is enabled.');

export default Component.extend({
  bits: injectService(),
  bitsPinnedCheers: injectService(),
  session: injectService(),
  notify: injectService(),

  user: null,
  pinRecentCheers: null,
  pinTopCheers: null,
  recentCheerMin: null,
  enableTimeout: null,
  recentCheerTimeout: 0,
  disableTimeout: computed('enableTimeout', function() {
    return !this.get('enableTimeout');
  }),

  actions: {
    // saving-button requires an action to be defined or it will throw an exception.
    // The save button action will be a no-op, and the button is marked as type="submit".
    // The save() action is defined as the action for the form.
    noop() {},

    save() {
      if (this.get('isSaving')) { return; }

      let recentCheerMin = parseInt(this.get('recentCheerMin'), 10);
      let recentCheerTimeout = this.get('enableTimeout') ? parseInt(this.get('recentCheerTimeout'), 10) : 0;
      let userId = this.get('user._id');
      let pinRecentCheers = this.get('pinRecentCheers');
      let pinTopCheers = this.get('pinTopCheers');

      let data = {
        pin_recent_cheers: pinRecentCheers,
        recent_cheer_min: recentCheerMin,
        recent_cheer_timeout: recentCheerTimeout,
        pin_top_cheers: pinTopCheers
      };

      let invalidConfig = pinRecentCheers && pinTopCheers && !recentCheerTimeout;

      if (invalidConfig) {
        this.get('notify').error(INVALID_ERROR);
        return;
      }

      this.set('isSaving', true);

      this.get('bits').setChannelSettings(userId, data).then(() => {
        if (this.isDestroyed) { return; }

        this.get('notify').success(SAVE_SUCCESS);
      }, () => {
        if (this.isDestroyed) { return; }

        this.get('notify').error(SAVE_ERROR);
      }).finally(() => {
        if (this.isDestroyed) { return; }

        this.set('isSaving', false);
      });
    },

    resetTopCheer() {
      let channelId = this.get('user._id');
      let userId = this.get('session.userData.id');

      this.get('bitsPinnedCheers').dismissMessage(userId, PINNED_CHEER_TYPES.TOP, channelId).then(() => {
        if (this.isDestroyed) { return; }

        this.get('notify').success(RESET_SUCCESS);
      }, () => {
        if (this.isDestroyed) { return; }

        this.get('notify').error(RESET_ERROR);
      });
    }
  }
});
