import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { LOCALSTORAGE_KEYS as BITS_STORAGE_KEYS } from 'web-client/utilities/bits/constants-config';

const RESERVED_CHAT_SPACE_TOP = 30;
const RESERVED_CHAT_SPACE_RECENT = 76;

export default Component.extend({
  bitsRoom: injectService(),
  bitsStrings: injectService(),
  bitsPinnedCheers: injectService(),
  storage: injectService(),
  settings: injectService('chatSettings'),
  session: injectService(),

  useDarkAssets: computed.readOnly('settings.darkMode'),
  showMessageFlags: computed.readOnly('settings.showMessageFlags'),
  showModIcons: computed.readOnly('settings.showModIcons'),
  showModerationActions: computed.readOnly('settings.showModerationActions'),
  showTwitchBotActions: computed.readOnly('settings.showTwitchBotActions'),
  showTimestamps: computed.readOnly('settings.showTimestamps'),

  isPinnedCheerExpanded: false,
  showTopCheerA: computed.readOnly('bitsPinnedCheers.showTopCheerA'),
  showRecentCheerA: computed.readOnly('bitsPinnedCheers.showRecentCheerA'),

  classNames: ['sticky-message', 'sticky-message--pinned-cheers', 'pinned-cheers'],
  classNameBindings: [
    'isVisible::hidden',
    'settings.showModIcons:showModIcons:hideModIcons',
    'settings.showTimestamps:showTimestamps:hideTimestamps'
  ],

  hasPinnedCheer: computed('bitsPinnedCheers.recentPinnedCheer', 'bitsPinnedCheers.topPinnedCheer', function() {
    return this.get('bitsPinnedCheers.recentPinnedCheer') !== null || this.get('bitsPinnedCheers.topPinnedCheer') !== null;
  }),

  recentPinnedCheerPseudoArrayA: computed.collect('bitsPinnedCheers.recentPinnedCheerA'),
  recentPinnedCheerPseudoArrayB: computed.collect('bitsPinnedCheers.recentPinnedCheerB'),

  topPinnedCheerPseudoArrayA: computed.collect('bitsPinnedCheers.topPinnedCheerA'),
  topPinnedCheerPseudoArrayB: computed.collect('bitsPinnedCheers.topPinnedCheerB'),

  showTopPinnedCheer: computed.empty('bitsPinnedCheers.recentPinnedCheer'),
  showBroadcasterNotification: false,
  showViewerNotification: false,

  learnMoreUrl: 'https://blog.twitch.tv/introducing-pinned-cheers-8099cf5a1694',

  isVisible: computed('bitsStrings.isLoaded', 'hasPinnedCheer', 'showBroadcasterNotification', 'showViewerNotification', function () {
    // wait for strings service to be ready to prevent jank
    if (!this.get('bitsStrings.isLoaded')) {
      return false;
    }

    if (this.get('hasPinnedCheer') || this.get('showBroadcasterNotification') || this.get('showViewerNotification')) {
      return true;
    }

    return false;
  }),

  init() {
    this._super(...arguments);

    // don't check notifications if user isn't authenticated
    if (!this.get('session.isAuthenticated')) {
      return;
    }

    if (this.get('bitsRoom.isOwnChannel')) {
      if (this.get(`storage.${BITS_STORAGE_KEYS.SEEN_PCHEER_BROADCASTER_NOTIFICATION}`)) {
        this.set('showBroadcasterNotification', false);
      } else {
        this.set('showBroadcasterNotification', true);
      }
    } else {
      if (this.get(`storage.${BITS_STORAGE_KEYS.SEEN_PCHEER_VIEWER_NOTIFICATION}`)) {
        this.set('showViewerNotification', false);
      } else {
        this.set('showViewerNotification', true);
      }
    }
  },

  actions: {
    dismissBroadcasterNotification() {
      this.set(`storage.${BITS_STORAGE_KEYS.SEEN_PCHEER_BROADCASTER_NOTIFICATION}`, true);
      this.set('showBroadcasterNotification', false);
    },

    dismissViewerNotification() {
      this.set(`storage.${BITS_STORAGE_KEYS.SEEN_PCHEER_VIEWER_NOTIFICATION}`, true);
      this.set('showViewerNotification', false);
    },

    adjustContainer() {
      if (this.get('hasPinnedCheer')) {
        if (this.get('showTopPinnedCheer')) {
          this.get('adjustContainer')(RESERVED_CHAT_SPACE_TOP);
        } else {
          this.get('adjustContainer')(RESERVED_CHAT_SPACE_RECENT);
        }
      } else {
        // remove reserved chat space when no pinned cheer
        this.get('adjustContainer')(0);
      }
    }
  }
});
