import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  pinnedCheers: injectService('bits-pinned-cheers'),
  session: injectService(),
  chatSettings: injectService(),

  expandMessage: false,
  expandArrowVisible: false,

  //This will be overwritten in extensions of this component by the template that invokes those component extensions. This is here to prevent errors being thrown on willDestroyElement.
  adjustContainer() {},
  elementId: null,

  userData: computed.readOnly('session.userData'),

  didRender() {
    this._super(...arguments);
    this.get('adjustContainer')();
  },

  willDestroyElement() {
    this._super(...arguments);
    this.get('adjustContainer')();
  }
});
