import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { htmlSafe } from 'ember-string';
import { PINNED_CHEER_TYPES } from 'web-client/utilities/bits/constants-config';
import { commatized } from 'web-client/helpers/commatized';

export default Component.extend({
  classNames: ['js-bits-reset-top-cheer-dialog', 'bits-dialog', 'pos-fixed', 'z--space', 'border'],
  attributeBindings: ['style'],

  session: injectService(),
  bitsPinnedCheers: injectService(),

  userData: computed.readOnly('session.userData'),

  // provided by parent
  options: null,
  hide() {},

  // set internally
  channelName: null,
  username: null,
  cheerAmount: null,

  didReceiveAttrs() {
    this._super(...arguments);

    let { renderTop, renderLeft, channelName, username, cheerAmount } = this.get('options');
    cheerAmount = commatized(cheerAmount);

    this.set('style', htmlSafe(`top:${renderTop}px;left:${renderLeft}px`));
    this.setProperties({ channelName, username, cheerAmount });
  },

  actions: {
    resetTopCheer() {
      this.get('bitsPinnedCheers').dismissMessage(this.get('userData.id'), PINNED_CHEER_TYPES.TOP).then(this.get('hide'));
    },

    hideDialog() {
      this.get('hide')();
    }
  }
});
