import MessageLine from 'web-client/components/chat/message-line/component';

export default MessageLine.extend({
  labelWrapper: '',

  didReceiveAttrs() {
    this._super(...arguments);

    // [name] was mistakenly translated in some locales, so split on the brackets
    let topCheerParts = this.get('labelWrapper').toString().split(/\[.+\]/);
    this.set('labelWrapperPartOne', topCheerParts[0]);
    this.set('labelWrapperPartTwo', topCheerParts[1]);
  },

  didRender() {
    this._super(...arguments);

    if (this.get('postRenderAction')) {
      this.get('postRenderAction')();
    }
  },

  actions: {
    showModOverlay(sender) {
      let $this = this.$();
      this.sendAction('showModOverlay', {
        left: $this.offset().left - 120,
        top: $this.offset().top + $this.height() + 5,
        sender
      });
    }
  }
});
