import DefaultPinnedCheer from 'web-client/components/bits/pinned-cheers/default-pinned-cheer/component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const RESET_CONFIRM_VERTICAL_OFFSET = 10;

export default DefaultPinnedCheer.extend({
  pinnedCheers: injectService('bits-pinned-cheers'),
  session: injectService(),
  chatSettings: injectService(),
  bitsEmotes: injectService(),

  isViewerModeratorOrHigher: false,

  userData: computed.readOnly('session.userData'),

  showDismissButton: computed('userData.id', 'isViewerModeratorOrHigher','chatSettings.showModIcons',  function() {
    let canDismiss = this.get('pinnedCheers').canDismissPinnedCheer(this.get('userData.id'), this.get('isViewerModeratorOrHigher'));
    let isMyPinnedCheer = String(this.get('userData.id')) === this.get('pinnedCheers.topPinnedCheer.id');

    return isMyPinnedCheer || (canDismiss && this.get('chatSettings.showModIcons'));
  }),

  didReceiveAttrs() {
    this._super(...arguments);

    let bitsEmotesSvc = this.get('bitsEmotes');
    let message = this.get('cheerMessage.message');
    this.set('aggregateMessagePrefix', bitsEmotesSvc.getMessagePrefix(message));
  },

  actions: {
    dismissPinnedCheer() {
      let $dismissIcon = this.$('.pinned-cheers__dismiss');
      let { amount, from } = this.get('pinnedCheers.topPinnedCheer');

      this.get('showResetTopCheer')({
        left: $dismissIcon.offset().left,
        top: $dismissIcon.offset().top + $dismissIcon.height() + RESET_CONFIRM_VERTICAL_OFFSET,
        amount,
        from
      });
    },

    toggleExpandMessage() {
      this.toggleProperty('expandMessage');
    }
  }
});
