import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';

import {
  BITS_DARK_ANIMATED_PROMO_INTRO_URL,
  BITS_LIGHT_ANIMATED_PROMO_INTRO_URL
} from 'web-client/utilities/urls/static-cdn';

/*
  Tooltip shown while processing a Bits send
*/

export default Component.extend({
  classNames: ['js-bits-sending-bits'],
  bitsRoom: injectService(),
  bitsEmotes: injectService(),
  channelDisplayName: computed.readOnly('bitsRoom.channelDisplayName'),

  promoImgUrl: computed('bitsEmotes.isDarkChat', function () {
    return this.get('bitsEmotes.isDarkChat') ? BITS_DARK_ANIMATED_PROMO_INTRO_URL : BITS_LIGHT_ANIMATED_PROMO_INTRO_URL;
  })
});
